/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "so-util_base64-decode.h"

#define MAX_BASE64_BUFFER_SIZE 256

/* declare detection functions */
int rule17251eval(void *p);

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule17251flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule17251option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule17251flow0
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"Content-Type|3A| application/ms-tnef", relative, depth 0, nocase, fast_pattern; 
static ContentInfo rule17251content1 = 
{
    (uint8_t *) "Content-Type|3A| application/ms-tnef", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_FAST_PATTERN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17251option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17251content1
    }
};
// content:"Content-Transfer-Encoding|3A| base64", depth 0, nocase, relative; 
static ContentInfo rule17251content2 = 
{
    (uint8_t *) "Content-Transfer-Encoding|3A| base64", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17251option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17251content2
    }
};
// content:"|0D 0A 0D 0A|", depth 0, relative; 
static ContentInfo rule17251content3 = 
{
    (uint8_t *) "|0D 0A 0D 0A|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};


static RuleOption rule17251option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17251content3
    }
};

/* references for sid 17251 */
/* reference: cve "2010-2728"; */
static RuleReference rule17251ref1 = 
{
    "cve", /* type */
    "2010-2728" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-064"; */
static RuleReference rule17251ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-064" /* value */
};

static RuleReference *rule17251refs[] =
{
    &rule17251ref1,
    &rule17251ref2,
    NULL
};

/* metadata for sid 17251 */
/* metadata:service smtp, policy security-ips drop; */
static RuleMetaData rule17251service1 = 
{
    "service smtp"
};


//static RuleMetaData rule17251policy1 = 
//{
//    "policy security-ips drop"
//};


static RuleMetaData *rule17251metadata[] =
{
    &rule17251service1,
//    &rule17251policy1,
    NULL
};

RuleOption *rule17251options[] =
{
    &rule17251option0,
    &rule17251option1,
    &rule17251option2,
    &rule17251option3,
    NULL
};

Rule rule17251 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "25", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       17251, /* sigid */
       5, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-OFFICE Outlook RTF remote code execution attempt",     /* message */
       rule17251refs /* ptr to references */
       ,rule17251metadata
   },
   rule17251options, /* ptr to rule options */
   &rule17251eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule17251eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_buffer = 0;
    uint8_t decodedbuf[MAX_BASE64_BUFFER_SIZE], *decodedbuf_ptr, *decodedend_ptr;
    uint32_t decodedbytes, number_of_entries = 0, entry_ctr = 0, size_of_entry = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    uint32_t tmpval;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if (checkFlow(p, rule17251options[0]->option_u.flowFlags) > 0 ) {

        if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_buffer) != CURSOR_IN_BOUNDS) {
            return RULE_NOMATCH;
        }

        // content:"Content-Type|3A| application/ms-tnef", depth 0, relative, nocase, fast_pattern;
        while(contentMatch(p, rule17251options[1]->option_u.content, &cursor_normal) > 0) {
            
            // content:"Content-Transfer-Encoding|3A| base64", depth 0, nocase, relative;
            if (contentMatch(p, rule17251options[2]->option_u.content, &cursor_normal) <= 0) {
                continue;
            }

            // content:"|0D 0A 0D 0A|", depth 0, relative;
            if (contentMatch(p, rule17251options[3]->option_u.content, &cursor_normal) <= 0) {
               continue;
            }

            // Make sure we can actually decode the data
            if(base64decode(cursor_normal, MAX_BASE64_BUFFER_SIZE, decodedbuf, sizeof(decodedbuf), &decodedbytes) < 0) {
                continue; 
            }

            // Keep the decodedbuf for later
            decodedbuf_ptr = decodedbuf;
            decodedend_ptr = decodedbuf_ptr + decodedbytes;

            // Make sure there's enough data to get through the first iteration
            if(decodedbytes < 22)
               return RULE_NOMATCH;

            // Verify the TNEF header
            tmpval =  *decodedbuf_ptr++;
            tmpval |= *decodedbuf_ptr++ << 8;
            tmpval |= *decodedbuf_ptr++ << 16;
            tmpval |= *decodedbuf_ptr++ << 24; 

            if(tmpval == 0x223E9F78) {

                tmpval = *decodedbuf_ptr++;
                tmpval |= *decodedbuf_ptr++ << 8;

                if(tmpval == 0x0001) {

                    // Message level
                    if((*decodedbuf_ptr++ == 0x01)) {
                    
                        // Message Identifier
                        decodedbuf_ptr += 4;

                        // Search for PidTagRtfCompressed
                        while(decodedbuf_ptr + 12 < decodedend_ptr) {
                            tmpval =  *decodedbuf_ptr++;
                            tmpval |= *decodedbuf_ptr++ << 8;
                            tmpval |= *decodedbuf_ptr++ << 16;
                            tmpval |= *decodedbuf_ptr++ << 24;

                            if(tmpval == 0x10090102) {
                                number_of_entries = *decodedbuf_ptr++;
                                number_of_entries |= *decodedbuf_ptr++ << 8;
                                number_of_entries |= *decodedbuf_ptr++ << 16;
                                number_of_entries |= *decodedbuf_ptr++ << 24;

                                // Limiting to 10 in case of a dos
                                if(number_of_entries < 10) {

                                   for(entry_ctr = 0; entry_ctr < number_of_entries; entry_ctr++) {

                                       if(decodedbuf_ptr + 8 > decodedend_ptr)
                                           return RULE_NOMATCH;

                                       decodedbuf_ptr += 4;

                                       // Check for vulnerable condition
                                       tmpval = *decodedbuf_ptr++;
                                       tmpval |= *decodedbuf_ptr++ << 8;
                                       tmpval |= *decodedbuf_ptr++ << 16;
                                       tmpval |= *decodedbuf_ptr++ << 24;

                                       if(tmpval < 12) {
                                           return RULE_MATCH;
                                       }

                                       if(decodedbuf_ptr + 4 > decodedend_ptr)
                                           return RULE_NOMATCH;

                                       // Guess it's okay.  Skip.
                                       size_of_entry = *decodedbuf_ptr++;
                                       size_of_entry |= *decodedbuf_ptr++ << 8;
                                       size_of_entry |= *decodedbuf_ptr++ << 16;
                                       size_of_entry |= *decodedbuf_ptr++ << 24;

                                       // Jump the rest of the blob
                                       decodedbuf_ptr += size_of_entry;

                                       // any padding
                                       decodedbuf_ptr += (size_of_entry % 16);

                                       // and two byte checksum
                                       decodedbuf_ptr += 2;
                                   }
                                }
                            }
                            else {
                               // Rollback 4 bytes if we didn't find out value
                               decodedbuf_ptr -= 3;
                               continue;
                            }

                            decodedbuf_ptr++;
                        }
                    }
                }
            }
        }
    }

    return RULE_NOMATCH;
}
/*
Rule *rules[] = {
    &rule17251,
    NULL
};
*/
